<?php
/*
Plugin Name: ConectaKS Chat
Description: Adds a floating, animated button that opens AI chat with responsive positioning for mobile and desktop. Supports all pages or specific page selection.
Version: 2.0
Author: Raul Sokacheski
*/
// Admin settings menu
// Enqueue scripts necessários para o uploader
add_action('admin_enqueue_scripts', function($hook) {
    if ($hook === 'settings_page_conectaks-chat') {
        wp_enqueue_media();
        wp_enqueue_script('jquery');
    }
});

add_action('admin_menu', function() {
    add_options_page('ConectaKS Chat Button', 'ConectaKS Chat', 'manage_options', 'conectaks-chat', function() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST['bottom_desktop'])) update_option('conectaks_chat_bottom_desktop', sanitize_text_field($_POST['bottom_desktop']));
            if (isset($_POST['right_desktop'])) update_option('conectaks_chat_right_desktop', sanitize_text_field($_POST['right_desktop']));
            if (isset($_POST['bottom_mobile'])) update_option('conectaks_chat_bottom_mobile', sanitize_text_field($_POST['bottom_mobile']));
            if (isset($_POST['right_mobile'])) update_option('conectaks_chat_right_mobile', sanitize_text_field($_POST['right_mobile']));
            if (isset($_POST['chat_url'])) update_option('conectaks_chat_url', esc_url_raw($_POST['chat_url']));
            if (isset($_POST['page_display_mode'])) update_option('conectaks_chat_page_display_mode', sanitize_text_field($_POST['page_display_mode']));
            if (isset($_POST['selected_pages'])) {
                $selected_pages = array_map('intval', $_POST['selected_pages']);
                update_option('conectaks_chat_selected_pages', $selected_pages);
            } else {
                update_option('conectaks_chat_selected_pages', array());
            }
            if (isset($_POST['chat_icon'])) update_option('conectaks_chat_icon', esc_url_raw($_POST['chat_icon']));
            if (isset($_POST['button_color'])) update_option('conectaks_chat_button_color', sanitize_hex_color($_POST['button_color']));
            if (isset($_POST['button_hover_color'])) update_option('conectaks_chat_button_hover_color', sanitize_hex_color($_POST['button_hover_color']));
            if (isset($_POST['hover_message'])) update_option('conectaks_chat_hover_message', sanitize_text_field($_POST['hover_message']));
            if (isset($_POST['hover_text_color'])) update_option('conectaks_chat_hover_text_color', sanitize_hex_color($_POST['hover_text_color']));
            if (isset($_POST['hover_bg_color'])) update_option('conectaks_chat_hover_bg_color', sanitize_hex_color($_POST['hover_bg_color']));
            echo '<div class="updated"><p>Configurações atualizadas!</p></div>';
        }
        $bottom_desktop = esc_attr(get_option('conectaks_chat_bottom_desktop', '30px'));
        $right_desktop = esc_attr(get_option('conectaks_chat_right_desktop', '20px'));
        $bottom_mobile = esc_attr(get_option('conectaks_chat_bottom_mobile', '20px'));
        $right_mobile = esc_attr(get_option('conectaks_chat_right_mobile', '10px'));
        $chat_url = esc_url(get_option('conectaks_chat_url', ''));
        $page_display_mode = esc_attr(get_option('conectaks_chat_page_display_mode', 'all'));
        $selected_pages = get_option('conectaks_chat_selected_pages', array());
        $chat_icon = esc_url(get_option('conectaks_chat_icon', ''));
        $button_color = esc_attr(get_option('conectaks_chat_button_color', '#4b0082'));
        $button_hover_color = esc_attr(get_option('conectaks_chat_button_hover_color', '#6a0dad'));
        $hover_message = esc_attr(get_option('conectaks_chat_hover_message', 'Vamos conversar!'));
        $hover_text_color = esc_attr(get_option('conectaks_chat_hover_text_color', '#ffffff'));
        $hover_bg_color = esc_attr(get_option('conectaks_chat_hover_bg_color', '#4b0082'));
        
        // Buscar todas as páginas do WordPress
        $pages = get_pages(array(
            'post_status' => 'publish',
            'sort_column' => 'post_title',
            'sort_order' => 'ASC'
        ));
        
        // Buscar posts também
        $posts = get_posts(array(
            'post_status' => 'publish',
            'numberposts' => -1,
            'orderby' => 'title',
            'order' => 'ASC'
        ));
        ?>
        <style>
        .conectaks-admin-wrap {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
            margin: -20px -20px 0 -20px;
        }
        .conectaks-admin-container {
            background: white;
            border-radius: 15px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            overflow: hidden;
            max-width: 1200px;
            margin: 0 auto;
        }
        .conectaks-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 50%, #f093fb 100%);
            color: white;
            padding: 40px;
            text-align: center;
            position: relative;
            overflow: hidden;
        }
        .conectaks-header::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(255,255,255,0.15) 0%, transparent 70%);
            animation: float 8s ease-in-out infinite;
        }
        .conectaks-header::after {
            content: '';
            position: absolute;
            bottom: -30%;
            right: -30%;
            width: 150%;
            height: 150%;
            background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 60%);
            animation: float 12s ease-in-out infinite reverse;
        }
        @keyframes float {
            0%, 100% { transform: translate(-50%, -50%) rotate(0deg) scale(1); }
            50% { transform: translate(-50%, -50%) rotate(180deg) scale(1.1); }
        }
        .conectaks-header h1 {
            margin: 0;
            font-size: 3em;
            font-weight: 800;
            text-shadow: 3px 3px 6px rgba(0,0,0,0.4);
            position: relative;
            z-index: 1;
            background: linear-gradient(45deg, #fff, #f0f0f0);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            line-height: 1.2;
            letter-spacing: -1px;
        }
        .conectaks-subtitle {
            margin: 15px 0 0 0;
            font-size: 1.3em;
            opacity: 0.95;
            position: relative;
            z-index: 1;
            font-weight: 300;
        }
        .conectaks-header-icons {
            position: absolute;
            top: 20px;
            right: 20px;
            font-size: 2em;
            opacity: 0.3;
            animation: bounce 2s infinite;
        }
        @keyframes bounce {
            0%, 20%, 50%, 80%, 100% { transform: translateY(0); }
            40% { transform: translateY(-10px); }
            60% { transform: translateY(-5px); }
        }
        .conectaks-content {
            padding: 40px;
        }
        .conectaks-section {
            background: linear-gradient(145deg, #ffffff 0%, #f8f9fa 100%);
            border-radius: 20px;
            padding: 30px;
            margin-bottom: 35px;
            border: 1px solid rgba(102, 126, 234, 0.1);
            box-shadow: 0 10px 30px rgba(0,0,0,0.08);
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            overflow: hidden;
        }
        .conectaks-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, #667eea, #764ba2, #f093fb);
            border-radius: 20px 20px 0 0;
        }
        .conectaks-section:hover {
            transform: translateY(-5px) scale(1.02);
            box-shadow: 0 20px 40px rgba(0,0,0,0.15);
            border-color: rgba(102, 126, 234, 0.2);
        }
        .conectaks-section h3 {
            color: #2d3748;
            margin: 0 0 25px 0;
            font-size: 1.6em;
            font-weight: 700;
            display: flex;
            align-items: center;
            gap: 15px;
            position: relative;
        }
        .conectaks-section h3::before {
            content: '';
            width: 50px;
            height: 50px;
            background: linear-gradient(135deg, #667eea, #764ba2);
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.2em;
            color: white;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
        }
        .conectaks-section:nth-child(1) h3::before { content: '🤖'; }
        .conectaks-section:nth-child(2) h3::before { content: '📍'; }
        .conectaks-section:nth-child(3) h3::before { content: '🖥️'; }
        .conectaks-section:nth-child(4) h3::before { content: '📱'; }
        .conectaks-section:nth-child(5) h3::before { content: '🎨'; }
        .conectaks-section:nth-child(6) h3::before { content: '💬'; }
        .conectaks-form-group {
            margin-bottom: 20px;
        }
        .conectaks-form-group label {
            display: block;
            font-weight: 600;
            color: #333;
            margin-bottom: 8px;
            font-size: 1.1em;
        }
        .conectaks-form-group input[type="text"],
        .conectaks-form-group input[type="url"],
        .conectaks-form-group input[type="color"] {
            width: 100%;
            max-width: 400px;
            padding: 15px 20px;
            border: 2px solid #e2e8f0;
            border-radius: 12px;
            font-size: 16px;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            background: #ffffff;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }
        .conectaks-form-group input[type="text"]:focus,
        .conectaks-form-group input[type="url"]:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.1), 0 4px 12px rgba(0,0,0,0.1);
            transform: translateY(-1px);
        }
        .conectaks-form-group input[type="color"] {
            width: 120px;
            height: 60px;
            border: 3px solid #e2e8f0;
            border-radius: 12px;
            cursor: pointer;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
            transition: all 0.3s ease;
        }
        .conectaks-form-group input[type="color"]:hover {
            transform: scale(1.08);
            box-shadow: 0 8px 25px rgba(0,0,0,0.2);
            border-color: #667eea;
        }
        .conectaks-form-group small {
            color: #666;
            font-style: italic;
            margin-top: 5px;
            display: block;
        }
        .conectaks-button {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            padding: 8px 16px;
            border-radius: 8px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            box-shadow: 0 2px 8px rgba(102, 126, 234, 0.3);
            position: relative;
            overflow: hidden;
        }
        .conectaks-button::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
            transition: left 0.5s;
        }
        .conectaks-button:hover::before {
            left: 100%;
        }
        .conectaks-button:hover {
            transform: translateY(-2px) scale(1.03);
            box-shadow: 0 4px 12px rgba(102, 126, 234, 0.4);
        }
        .conectaks-button-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 50%, #f093fb 100%);
            box-shadow: 0 3px 12px rgba(102, 126, 234, 0.4);
            font-size: 16px;
            padding: 12px 30px;
            border-radius: 10px;
        }
        .conectaks-button-primary:hover {
            box-shadow: 0 5px 18px rgba(102, 126, 234, 0.5);
            transform: translateY(-2px) scale(1.05);
        }
        .conectaks-radio-group {
            display: flex;
            gap: 20px;
            margin: 15px 0;
        }
        .conectaks-radio-item {
            display: flex;
            align-items: center;
            gap: 8px;
            padding: 15px 20px;
            background: white;
            border: 2px solid #e1e5e9;
            border-radius: 8px;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        .conectaks-radio-item:hover {
            border-color: #4b0082;
            background: #f8f9ff;
        }
        .conectaks-radio-item input[type="radio"] {
            margin: 0;
        }
        .conectaks-radio-item input[type="radio"]:checked + strong {
            color: #4b0082;
        }
        .conectaks-page-selection {
            background: white;
            border: 2px solid #e1e5e9;
            border-radius: 8px;
            padding: 20px;
            margin-top: 15px;
        }
        .conectaks-search-box {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #e1e5e9;
            border-radius: 8px;
            font-size: 16px;
            margin-bottom: 15px;
        }
        .conectaks-search-box:focus {
            outline: none;
            border-color: #4b0082;
            box-shadow: 0 0 0 3px rgba(75, 0, 130, 0.1);
        }
        .conectaks-button-group {
            display: flex;
            gap: 10px;
            margin-bottom: 15px;
        }
        .conectaks-button-small {
            padding: 6px 12px;
            font-size: 12px;
        }
        .conectaks-pages-list {
            max-height: 300px;
            overflow-y: auto;
            border: 1px solid #e1e5e9;
            border-radius: 8px;
            padding: 15px;
            background: #f8f9fa;
        }
        .conectaks-pages-list h5 {
            color: #4b0082;
            margin: 0 0 15px 0;
            font-size: 1.1em;
        }
        .conectaks-page-item {
            display: block;
            margin: 8px 0;
            padding: 8px 12px;
            background: white;
            border-radius: 6px;
            transition: background 0.3s ease;
        }
        .conectaks-page-item:hover {
            background: #f0f0ff;
        }
        .conectaks-image-upload {
            display: flex;
            gap: 10px;
            align-items: center;
            margin-bottom: 15px;
        }
        .conectaks-image-upload input {
            flex: 1;
        }
        .conectaks-image-preview {
            margin-top: 15px;
        }
        .conectaks-image-preview img {
            border-radius: 50%;
            border: 3px solid #4b0082;
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }
        .conectaks-success-message {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 20px;
            font-weight: 600;
        }
        @media (max-width: 768px) {
            .conectaks-admin-wrap {
                padding: 10px;
            }
            .conectaks-content {
                padding: 20px;
            }
            .conectaks-radio-group {
                flex-direction: column;
            }
            .conectaks-button-group {
                flex-wrap: wrap;
            }
            .conectaks-header {
                padding: 30px 20px;
            }
            .conectaks-header h1 {
                font-size: 2.2em;
                line-height: 1.1;
            }
            .conectaks-subtitle {
                font-size: 1.1em;
                margin-top: 10px;
            }
            .conectaks-header-icons {
                font-size: 1.5em;
                top: 15px;
                right: 15px;
            }
        }
        </style>
        
        <div class='conectaks-admin-wrap'>
            <div class='conectaks-admin-container'>
                <div class='conectaks-header'>
                    <div class='conectaks-header-icons'>🤖✨</div>
                    <h1>ConectaKS Chat</h1>
                    <p class='conectaks-subtitle'>Configure seu assistente de IA personalizado</p>
                </div>
                
                <div class='conectaks-content'>
                    <?php if (isset($_POST) && !empty($_POST)): ?>
                        <div class='conectaks-success-message'>
                            ✅ Configurações atualizadas com sucesso!
                        </div>
                    <?php endif; ?>
                    
                    
                    <form method='post'>
                        <div class='conectaks-section'>
                            <h3>Configurações do Assistente</h3>
                            <div class='conectaks-form-group'>
                                <label>URL do Assistente</label>
                                <input type='url' name='chat_url' value='<?php echo $chat_url; ?>'>
                                <small>URL completa do seu assistente de IA (ex: https://chat.openai.com/g/g-xxxxx)</small>
                            </div>
                        </div>
                        
                        <div class='conectaks-section'>
                <h3>Onde Exibir o Botão</h3>
                            <div class='conectaks-radio-group'>
                                <label class='conectaks-radio-item'>
                    <input type='radio' name='page_display_mode' value='all' <?php echo ($page_display_mode === 'all') ? 'checked' : ''; ?> onchange='togglePageSelection()'>
                    <strong>Todas as páginas</strong>
                                </label>
                                <label class='conectaks-radio-item'>
                    <input type='radio' name='page_display_mode' value='specific' <?php echo ($page_display_mode === 'specific') ? 'checked' : ''; ?> onchange='togglePageSelection()'>
                    <strong>Páginas específicas</strong>
                                </label>
                            </div>
                
                            <div id='page-selection' class='conectaks-page-selection' style='<?php echo ($page_display_mode === 'specific') ? '' : 'display: none;'; ?>'>
                    <h4>Selecione as páginas onde o botão deve aparecer:</h4>
                                <input type='text' id='page-search' placeholder='Buscar páginas...' class='conectaks-search-box' onkeyup='filterPages()'>
                                <div class='conectaks-button-group'>
                                    <button type='button' onclick='selectAllPages()' class='conectaks-button conectaks-button-small'>Selecionar Todas</button>
                                    <button type='button' onclick='deselectAllPages()' class='conectaks-button conectaks-button-small'>Deselecionar Todas</button>
                        </div>
                                <div id='pages-list' class='conectaks-pages-list'>
                            <?php
                            // Adicionar páginas
                            if (!empty($pages)) {
                                echo "<h5>Páginas:</h5>";
                                foreach ($pages as $page) {
                                    $checked = in_array($page->ID, $selected_pages) ? 'checked' : '';
                                            echo "<label class='conectaks-page-item'><input type='checkbox' name='selected_pages[]' value='{$page->ID}' $checked class='page-checkbox' data-title='" . esc_attr($page->post_title) . "'> " . esc_html($page->post_title) . " (ID: {$page->ID})</label>";
                                }
                            }
                            
                            // Adicionar posts
                            if (!empty($posts)) {
                                echo "<h5>Posts:</h5>";
                                foreach ($posts as $post) {
                                    $checked = in_array($post->ID, $selected_pages) ? 'checked' : '';
                                            echo "<label class='conectaks-page-item'><input type='checkbox' name='selected_pages[]' value='{$post->ID}' $checked class='page-checkbox' data-title='" . esc_attr($post->post_title) . "'> " . esc_html($post->post_title) . " (ID: {$post->ID})</label>";
                                }
                            }
                            ?>
                        </div>
                                <small>Use a busca para encontrar páginas específicas rapidamente</small>
                    </div>
                </div>
                
                        <div class='conectaks-section'>
                <h3>Posicionamento - Desktop</h3>
                            <div class='conectaks-form-group'>
                                <label>Distância do fundo</label>
                                <input type='text' name='bottom_desktop' value='<?php echo $bottom_desktop; ?>'>
                                <small>Distância do botão em relação ao fundo da tela (ex: 30px)</small>
                            </div>
                            <div class='conectaks-form-group'>
                                <label>Distância da direita</label>
                                <input type='text' name='right_desktop' value='<?php echo $right_desktop; ?>'>
                                <small>Distância do botão em relação à direita da tela (ex: 20px)</small>
                            </div>
                        </div>
                        
                        <div class='conectaks-section'>
                <h3>Posicionamento - Mobile</h3>
                            <div class='conectaks-form-group'>
                                <label>Distância do fundo</label>
                                <input type='text' name='bottom_mobile' value='<?php echo $bottom_mobile; ?>'>
                                <small>Distância do botão em relação ao fundo da tela no mobile (ex: 20px)</small>
                            </div>
                            <div class='conectaks-form-group'>
                                <label>Distância da direita</label>
                                <input type='text' name='right_mobile' value='<?php echo $right_mobile; ?>'>
                                <small>Distância do botão em relação à direita da tela no mobile (ex: 10px)</small>
                            </div>
                        </div>
                        
                        <div class='conectaks-section'>
                <h3>Personalização</h3>
                            <div class='conectaks-form-group'>
                                <label>Imagem do botão</label>
                                <div class='conectaks-image-upload'>
                                    <input type='url' id='chat_icon' name='chat_icon' value='<?php echo $chat_icon; ?>' placeholder='URL da imagem ou use o botão abaixo'>
                                    <button type='button' id='upload_image_button' class='conectaks-button'>📁 Escolher Imagem</button>
                                    <button type='button' id='remove_image_button' class='conectaks-button'>🗑️ Remover</button>
                </div>
                                <div id='image_preview' class='conectaks-image-preview'>
                    <?php if ($chat_icon): ?>
                                        <img src='<?php echo $chat_icon; ?>' style='max-width: 100px; max-height: 100px;'>
                    <?php endif; ?>
                </div>
                                <small>Escolha uma imagem ou cole a URL. Deixe vazio para usar o emoji padrão 🤖</small>
                            </div>
                            
                            <div class='conectaks-form-group'>
                                <label>Cor do botão</label>
                                <input type='color' name='button_color' value='<?php echo $button_color; ?>'>
                                <small>Escolha a cor de fundo do botão</small>
                            </div>
                            
                            <div class='conectaks-form-group'>
                                <label>Cor do botão (hover)</label>
                                <input type='color' name='button_hover_color' value='<?php echo $button_hover_color; ?>'>
                                <small>Cor quando o mouse passar por cima do botão</small>
                            </div>
                        </div>
                        
                        <div class='conectaks-section'>
                            <h3>Mensagem do Hover</h3>
                            <div class='conectaks-form-group'>
                                <label>Texto da mensagem</label>
                                <input type='text' name='hover_message' value='<?php echo $hover_message; ?>'>
                                <small>Mensagem que aparece quando o mouse passa por cima do botão</small>
                            </div>
                            
                            <div class='conectaks-form-group'>
                                <label>Cor do texto da mensagem</label>
                                <input type='color' name='hover_text_color' value='<?php echo $hover_text_color; ?>'>
                                <small>Cor do texto da mensagem de hover</small>
                            </div>
                            
                            <div class='conectaks-form-group'>
                                <label>Cor de fundo da mensagem</label>
                                <input type='color' name='hover_bg_color' value='<?php echo $hover_bg_color; ?>'>
                                <small>Cor de fundo da mensagem de hover</small>
                            </div>
                        </div>
                        
                                                <div style='text-align: center; margin-top: 40px;'>
                            <input type='submit' class='conectaks-button conectaks-button-primary' value='💾 Salvar Configurações'>
                        </div>
            </form>
                    
                </div>
            </div>
        </div>
        
        <script>
        // Uploader de imagem do WordPress
        // Uploader de imagem do WordPress
        jQuery(document).ready(function($) {
            var custom_uploader;
            
            $('#upload_image_button').click(function(e) {
                e.preventDefault();
                
                if (custom_uploader) {
                    custom_uploader.open();
                    return;
                }
                
                custom_uploader = wp.media({
                    title: 'Escolher Imagem do Botão',
                    button: {
                        text: 'Usar esta imagem'
                    },
                    multiple: false
                });
                
                custom_uploader.on('select', function() {
                    var attachment = custom_uploader.state().get('selection').first().toJSON();
                    $('#chat_icon').val(attachment.url);
                    $('#image_preview').html('<img src="' + attachment.url + '" style="max-width: 100px; max-height: 100px;">');
                });
                
                custom_uploader.open();
            });
            
            $('#remove_image_button').click(function(e) {
                e.preventDefault();
                $('#chat_icon').val('');
                $('#image_preview').html('');
            });
        });
        
        function togglePageSelection() {
            const specificMode = document.querySelector('input[name="page_display_mode"][value="specific"]').checked;
            const pageSelection = document.getElementById('page-selection');
            pageSelection.style.display = specificMode ? 'block' : 'none';
        }
        
        function filterPages() {
            const searchTerm = document.getElementById('page-search').value.toLowerCase();
            const checkboxes = document.querySelectorAll('.page-checkbox');
            
            checkboxes.forEach(function(checkbox) {
                const label = checkbox.parentElement;
                const title = checkbox.getAttribute('data-title').toLowerCase();
                
                if (title.includes(searchTerm)) {
                    label.style.display = 'block';
                } else {
                    label.style.display = 'none';
                }
            });
        }
        
        // Selecionar/Deselecionar todos
        function selectAllPages() {
            const checkboxes = document.querySelectorAll('.page-checkbox');
            checkboxes.forEach(function(checkbox) {
                checkbox.checked = true;
            });
        }
        
        function deselectAllPages() {
            const checkboxes = document.querySelectorAll('.page-checkbox');
            checkboxes.forEach(function(checkbox) {
                checkbox.checked = false;
            });
        }
        </script>
        <?php
    });
});

// Output button with responsive positioning
add_action('wp_footer', function() {
    // Verificar se o botão já foi adicionado para evitar duplicação
    static $button_added = false;
    if ($button_added) return;
    $button_added = true;
    
    $page_display_mode = get_option('conectaks_chat_page_display_mode', 'all');
    $selected_pages = get_option('conectaks_chat_selected_pages', array());
    
    // Se o modo for 'specific' e há páginas selecionadas, verificar se a página atual está na lista
    if ($page_display_mode === 'specific' && !empty($selected_pages)) {
        $current_page_id = get_the_ID();
        if (!in_array($current_page_id, $selected_pages)) return;
    }
    // Se o modo for 'all', o botão aparece em todas as páginas (não precisa de verificação)
    $bottom_desktop = esc_attr(get_option('conectaks_chat_bottom_desktop', '30px'));
    $right_desktop = esc_attr(get_option('conectaks_chat_right_desktop', '20px'));
    $bottom_mobile = esc_attr(get_option('conectaks_chat_bottom_mobile', '20px'));
    $right_mobile = esc_attr(get_option('conectaks_chat_right_mobile', '10px'));
    $chat_url = esc_url(get_option('conectaks_chat_url', 'https://chat.openai.com/'));
    $chat_icon = esc_url(get_option('conectaks_chat_icon', ''));
    $button_color = esc_attr(get_option('conectaks_chat_button_color', '#4b0082'));
    $button_hover_color = esc_attr(get_option('conectaks_chat_button_hover_color', '#6a0dad'));
    $hover_message = esc_attr(get_option('conectaks_chat_hover_message', 'Vamos conversar!'));
    $hover_text_color = esc_attr(get_option('conectaks_chat_hover_text_color', '#ffffff'));
    $hover_bg_color = esc_attr(get_option('conectaks_chat_hover_bg_color', '#4b0082'));
    $content = $chat_icon ? "<img src='$chat_icon' alt='chat icon'>" : "🤖";
    echo <<<HTML
    <style>
    #conectaks-chat-btn {
        position: fixed;
        bottom: $bottom_desktop;
        right: $right_desktop;
        z-index: 999999999;
        background-color: $button_color;
        color: white;
        width: 70px;
        height: 70px;
        border-radius: 50%;
        box-shadow: 0 4px 10px rgba(0,0,0,0.3);
        cursor: pointer;
        font-size: 28px;
        line-height: 1;
        transition: background 0.3s;
        opacity: 0;
        animation: conectaksFadeIn 0.5s ease-in-out 0.3s forwards, conectaksPulse 2s infinite 1s;
        display: flex;
        align-items: center;
        justify-content: center;
        border: none;
        outline: none;
    }
    #conectaks-chat-btn img {
        width: 50px;
        height: 50px;
        border-radius: 50%;
        object-fit: cover;
        display: block;
    }
    /* Garantir que o botão seja perfeitamente circular */
    #conectaks-chat-btn * {
        box-sizing: border-box;
    }
    #conectaks-chat-btn:hover {
        background-color: $button_hover_color;
    }
    #conectaks-chat-btn::after {
        content: '$hover_message';
        position: absolute;
        right: 70px;
        top: 50%;
        transform: translateY(-50%);
        background: $hover_bg_color;
        color: $hover_text_color;
        padding: 6px 10px;
        border-radius: 8px;
        white-space: nowrap;
        font-size: 14px;
        opacity: 0;
        transition: opacity 0.3s ease-in-out;
        pointer-events: none;
    }
    #conectaks-chat-btn:hover::after {
        opacity: 1;
    }
    @media screen and (max-width: 768px) {
        #conectaks-chat-btn {
            bottom: $bottom_mobile !important;
            right: $right_mobile !important;
        }
    }
    @keyframes conectaksFadeIn {
        0% { opacity: 0; }
        100% { opacity: 1; }
    }
    @keyframes conectaksPulse {
        0% { transform: scale(1); }
        50% { transform: scale(1.1); }
        100% { transform: scale(1); }
    }
    </style>
    <div id="conectaks-chat-btn" onclick="window.open('$chat_url','_blank')">$content</div>
    HTML;
});
